'use client';

import { useState, useEffect } from 'react';
import { getApiServerUrl } from '@/config/serverConfig';

interface User {
  id: string;
  username: string;
  email: string;
  role: string;
  name?: string;
}

interface AuthState {
  user: User | null;
  isLoading: boolean;
  isAuthenticated: boolean;
  isInitialized: boolean;
}

export function useAuth(): AuthState {
  const [authState, setAuthState] = useState<AuthState>({
    user: null,
    isLoading: true,
    isAuthenticated: false,
    isInitialized: false,
  });

  useEffect(() => {
    // 디버깅을 위한 localStorage 정보 출력
    // console.log('useAuth: localStorage 정보:', {
    //   userToken: localStorage.getItem('userToken') ? '있음' : '없음',
    //   username: localStorage.getItem('username'),
    //   userId: localStorage.getItem('userId'),
    //   userRole: localStorage.getItem('userRole'),
    // });

    const checkAuth = async () => {
      try {
        // localStorage에서 토큰 가져오기
        const token = localStorage.getItem('userToken');
        console.log('useAuth: 토큰 확인:', token ? '토큰 있음' : '토큰 없음');
        
        if (!token) {
          console.log('useAuth: 토큰이 없어서 인증되지 않은 상태로 설정');
          setAuthState({
            user: null,
            isLoading: false,
            isAuthenticated: false,
            isInitialized: true,
          });
          return;
        }

        // console.log('useAuth: API 서버로 직접 요청 시작');
        const API_SERVER = getApiServerUrl();
        console.log('useAuth: API 서버 URL:', `${API_SERVER}/auth/me`);
        
        const response = await fetch(`${API_SERVER}/auth/me`, {
          method: 'GET',
          headers: {
            'Authorization': `Bearer ${token}`,
          },
        });

        // console.log('useAuth: 응답 상태:', response.status, response.statusText);
        
        if (response.ok) {
          const data = await response.json();

          if (data.success && data.data) {
            // console.log('useAuth: 인증 성공, 사용자 정보:', data.data);
            // localStorage에서 실제 이름을 가져옴 (API에서 name이 없을 경우 대비)
            const storedName = localStorage.getItem('userName');

            setAuthState({
              user: {
                id: data.data.id.toString(),
                username: data.data.username,
                email: data.data.email,
                role: data.data.role,
                name: data.data.name || storedName || null
              },
              isLoading: false,
              isAuthenticated: true,
              isInitialized: true,
            });

            } else {
            // console.log('useAuth: 응답은 성공했지만 데이터가 유효하지 않음');
            setAuthState({
              user: null,
              isLoading: false,
              isAuthenticated: false,
              isInitialized: true,
            });
          }
        } else {
          console.log('useAuth: 응답 실패, 상태 코드:', response.status);
          const errorText = await response.text();
          console.log('useAuth: 오류 응답:', errorText);

  
          setAuthState({
            user: null,
            isLoading: false,
            isAuthenticated: false,
            isInitialized: true,
          });
        }
      } catch (error) {
        console.error('useAuth: 인증 확인 중 오류:', error);
        setAuthState({
          user: null,
          isLoading: false,
          isAuthenticated: false,
          isInitialized: true,
        });
      }
    };

    checkAuth();
  }, []);

  return authState;
} 