
CUBE-i Storage Kernel Security Module
============================================================

Mar 12, 2024
Copyright(c) 2024 UCUBE Corporation.

module infomation

![image](./app2.png)

log screen

![image](./app.png)


프로젝트 개요
========

CUBE-i Storage는 리눅스 기반 시스템의 보안을 강화하기 위해 개발된 커널 보안 모듈입니다. 이 모듈은 민감한 시스템 호출을 모니터링하고, 특정 조건에 따라 실행을 제한하는 기능을 제공하여, 시스템의 보안성을 향상시킵니다. 사용자 정의 규칙에 따라 불법적이거나 의심스러운 행위를 식별하고 차단할 수 있습니다.

기능 설명
========

 - 실행 파일 모니터링: execve 시스템 호출을 모니터링하여, 특정 사용자가 실행할 수 있는 파일을 제한합니다.
 - UID 기반 실행 제한: 특정 UID(사용자 식별자)에 대해서만 실행 파일 접근을 허용하거나 거부합니다. 기본적으로 UID 2000에 대해 제한을 설정하나, 이는 사용자의 요구에 따라 변경 가능합니다.
 - 커널 모듈의 시큐어 부팅 지원: 시큐어 부팅 환경에서도 사용할 수 있도록, 모듈은 서명되어야 하며, 사용자는 MOK(모듈 소유권 키)을 통해 서명 키를 시스템 UEFI에 등록해야 합니다.

설치 방법
========
CUBE-i Storage 모듈의 설치는 다음 단계를 통해 수행할 수 있습니다:

 - 모듈 소스 코드 다운로드: 프로젝트의 소스 코드를 시스템에 다운로드합니다.
 - 모듈 빌드: 소스 디렉토리에서 make 명령어를 실행하여 모듈을 빌드합니다.
 - 모듈 삽입: insmod 명령어를 사용하여 커널에 CUBE-i Storage 모듈을 삽입합니다.

sudo insmod cube-i.ko

삭제 방법
========
모듈 제거: rmmod 명령어를 사용하여 모듈을 제거합니다.


시큐어 부팅 환경에서의 사용
========

시큐어 부팅은 부팅 과정에서 커널 모듈과 드라이버 같은 코드가 신뢰할 수 있는 서명자에 의해 서명되었는지 검증합니다. CUBE-i Storage 모듈을 시큐어 부팅 환경에서 사용하기 위해서는 다음과 같은 절차를 따라야 합니다:

개인 키 및 공개 키 생성: 모듈을 서명하기 위한 개인 키와 공개 키를 생성합니다.
모듈 서명: 생성된 개인 키를 사용하여 CUBE-i Storage 모듈을 서명합니다.
공개 키 등록: 생성된 공개 키를 UEFI에 등록하기 위해 MOK 유틸리티(mokutil)를 사용합니다. 이 과정을 통해 시스템은 서명된 모듈을 신뢰할 수 있게 됩니다.